<?php
	$noADS = hasbadWords($site->metaTitle. " ".$site->metaDescription." ".$site->metaKeywords);
?>
<div class="container" id="main">
	<div class="row">

		<div class="col-lg-3 col-md-4">
			<div class="card card-block score-fixed">
						<h2 class="small text-xs-center"><?php echo __("Your Website Score is"); ?></h2>

						<div class=" circle" data-text="<?php echo __("Score Rank"); ?>"  data-fbw="5" data-bbw="5" data-color="#4390BE" data-percent="<?php echo $site->score; ?> "></div>
						
						<?php 
						$days			= getDaysDiff($site->updated,date("Y-m-d H:i:s"));

						if(intval($days) >= intval(config_item("update_inverval")))
						{
							?><button class="btn btn-outline-info btn-sm btn-block btn-update " data-domain="<?php echo $site->url; ?>"><i class="zmdi zmdi-refresh-alt"></i> <?php echo __("Update"); ?></button><?php
								
						}
						?>
						

				</div>


			
				<?php 
					if(!$noADS)
						echo get_ads("ads1","ads card card-block no-padding p-b-1 p-t-1"); 
				?>
				
			
			<?php if(count($similar)>1){ ?>
			<div class="card card-block">
				<h2 class="small  p-b-1"><?php echo __("Similar Ranking"); ?></h2>
				<?php foreach ($similar as $key => $value){ 
					if($value->id != $site->id){
					?>
				<div class="site-list">
					<div class="score"><?php echo $value->score; ?></div>
					<div class="data">
						<div class="title truncate"><?php echo badWords($value->metaTitle); ?></div>
						<a href="<?php echo base_url(); ?><?php echo $value->url; ?>" class="subtitle truncate"><?php echo badWords($value->url); ?></a>
					</div>
				</div>
				<?php } } ?>				
			</div>
			<?php } ?>

			<?php if(count($recents)>1){ ?>
			<div class="card card-block">
				<h2 class="small p-b-1"><?php echo __("Latest Sites"); ?></h2>
				<?php foreach ($recents as $key => $value){ 
					if($value->id != $site->id){
					?>
				<div class="site-list">
					<div class="score"><?php echo $value->score; ?></div>
					<div class="data">
						<div class="title truncate"><?php echo badWords($value->metaTitle); ?></div>
						<a href="<?php echo base_url(); ?><?php echo $value->url; ?>" class="subtitle truncate"><?php echo badWords($value->url); ?></a>
					</div>
				</div>
				<?php } } ?>				
			</div>
			<?php } ?>

		</div>



		<div class="col-lg-9 col-md-8">
			
			<div class="card card-block">		
				<div class="col-lg-12">
					<small class="text-muted pull-lg-right"><?php echo __("Last Updated"); ?>: <?php echo ago($site->updated); ?></small>
					<a class="small text-xs-center website" rel="nofollow external" target="_blank" href="http://<?php echo $site->url; ?> ">
					<i class="zmdi zmdi-globe"></i> <?php echo badWords($site->url); ?> 
					</a>	

					
					
				</div>

				<div class="col-lg-4 p-t-1">					
					
					<div class="screen animated bounceInUp">						
						<div class="m">
							<div class="web">
								<img class="img-fluid"  src="http://free.pagepeeker.com/v2/thumbs.php?size=x&url=<?php echo $site->url; ?>">
							</div>
							<div class="f">
								<div class="p"></div>
							</div>
						</div>
						<div class="f2"></div>	
					</div>						
				</div>
				<div class="col-lg-8 p-t-2">
					<div class="row">
						<?php
							$stats 		= getStatsData($site,$technologies);
							$optimize 	= $stats['optimize'];
							
						?>
						<div class="col-lg-12">
							<strong class="text d-block"><?php echo __("Success"); ?></strong>
							<small class="text-muted"><?php echo $stats["success"]; ?>% <?php echo __("of passed verification steps"); ?></small>
							<progress class="progress progress-success progress-sm" value="<?php echo $stats["success"]; ?>" max="100"></progress>
						</div>


						<div class="col-lg-12">
							<strong class="text d-block"><?php echo __("Warning"); ?></strong>
							<small class="text-muted"><?php echo $stats["warning"]; ?>% <?php echo __("of total warning"); ?></small>
							<progress class="progress progress-warning progress-sm" value="<?php echo $stats["warning"]; ?>" max="100"></progress>
						</div>

						<div class="col-lg-12">
							<strong class="text d-block"><?php echo __("Errors"); ?></strong>
							<small class="text-muted"><?php echo $stats["errors"]; ?>% <?php echo __("of total errors, require fast action"); ?></small>
							<progress class="progress progress-danger progress-sm" value="<?php echo $stats["errors"]; ?>" max="100"></progress>
						</div>
						


					

					</div>


					<?php 
					if(is_logged())
					{
						if(isBookmark($site->id)){ 
							?><div class="pull-right btn-bookmark btn btn-link" data-action="1" data-idsite="<?php echo $site->id; ?>"><i class="zmdi zmdi-star"></i> <?php echo __("Remove from bookmark"); ?></div><?php
						}else
						{
							?><div class="pull-right btn-bookmark btn btn-link" data-action="2"  data-idsite="<?php echo $site->id; ?>"><i class="zmdi zmdi-star-outline"></i> <?php echo __("Add to bookmark"); ?></div><?php
						}
					}
					?>

				<div class="pull-right btn btn-link btn-toggle-class" data-class="animated bounceIn" data-target="#share-block">
						<i class="zmdi zmdi-share"></i> <?php echo __("Share"); ?>
					</div>
				</div>

			</div>
			
			

		<div class="p-b-1" id="share-block">
			
			<div class="btn-group d-block " role="group" aria-label="Basic example">
				<?php
				$url_share =  urlencode(base_url().$site->url);
				?>
				<a href="#" data-url="http://www.facebook.com/sharer/sharer.php?u=<?php echo $url_share; ?>" class="btn btn-share btn-xs btn-facebook col-md-2"><i class="zmdi zmdi-facebook"></i> Facebook</a>
				<a href="#" data-url="https://twitter.com/home?status=<?php echo $url_share; ?>" class="btn btn-share btn-xs btn-twitter col-md-2"><i class="zmdi zmdi-twitter"></i> Twitter</a>
				<a href="#" data-url="https://plus.google.com/share?url=<?php echo $url_share; ?>" class="btn btn-share btn-xs btn-google col-md-2"><i class="zmdi zmdi-google-plus"></i> Google Plus</a>
				<a href="#" data-url="https://www.linkedin.com/shareArticle?mini=true&title=&summary=<?php echo $url_share; ?>&source=<?php echo $url_share; ?>&url=<?php echo $url_share; ?>" class="btn btn-share btn-xs btn-linkedin col-md-2"><i class="zmdi zmdi-linkedin"></i> Linkedin</a>
				<a href="#" data-url="https://pinterest.com/pin/create/button/?media=<?php echo $url_share; ?>&description=<?php echo $this->metaTitle; ?>&url=<?php echo $url_share; ?>" class="btn btn-share btn-xs btn-pinterest col-md-2"><i class="zmdi zmdi-pinterest"></i> Pinterest</a>
				<a href="#" data-url="mailto:?&body=<?php echo $url_share; ?>" class="btn btn-share btn-xs btn-info col-md-2"><i class="zmdi zmdi-pinterest"></i> Email</a>
			</div>
			<div class="clearfix"></div>
		</div>
		
			

			<div class="card card-block">	
				<div class="col-md-4">
					<div class="circle" data-text="<?php echo __("PageSpeed"); ?>" data-color="<?php echo colorCircle($site->pageSpeed,85); ?>" data-percent="<?php echo $site->pageSpeed; ?>"></div>
				</div>

				<div class="col-md-4">
					<div class="circle" data-text="<?php echo __("Bounce Rate"); ?>"  data-color="<?php echo colorCircle(50,$site->bounceRate); ?>" data-percent="<?php echo $site->bounceRate; ?>"></div>
				</div>

				<div class="col-md-4">
					<div class="circle" data-text="<?php echo __("Domain Authority"); ?>"  data-color="<?php echo colorCircle($site->domainAuthority,50); ?>" data-percent="<?php echo $site->domainAuthority; ?>"></div>
				</div>

			</div>

			<?php 
				if(!$noADS)
					echo get_ads("ads2","ads card card-block p-b-1"); 
				?>

			<div class="card card-block">	
				<div class="row p-t-2 ">
					<div class="col-lg-4">
						<?php
							$metaTitle = validateLenght($site->metaTitle,60,5);
						?>
						<strong><i class="zmdi <?php echo $metaTitle['icon']; ?> <?php echo $metaTitle['color']; ?> check"></i> <?php echo __("Title Tag"); ?></strong>
						<small class="text-muted d-block subtitle"><?php echo number_format($metaTitle['lenght']); ?> <?php echo __("Characters"); ?></small>
					</div>
					<div class="col-lg-8">
						<?php echo $metaTitle['fixed']; ?>
					</div>
				</div>

				<div class="row  p-t-2">
					<div class="col-lg-4">

						<?php
							$metaDescription = validateLenght($site->metaDescription,150,10);
						?>

						<strong><i class="zmdi <?php echo $metaDescription['icon']; ?> <?php echo $metaDescription['color']; ?> check"></i> <?php echo __("Meta Description"); ?></strong>
						<small class="text-muted d-block subtitle"><?php echo number_format($metaDescription['lenght']); ?> <?php echo __("Characters"); ?></small>
					</div>
					<div class="col-lg-8">
						<?php echo $metaDescription['fixed']; ?>
						
					</div>
				</div>

				<?php if($site->metaKeywords != ''){ ?>
				<div class="row  p-t-2">
					<div class="col-lg-4">
						<?php
						$keywords = explode(",",$site->metaKeywords);
						$keywordsCount = count($keywords);
						if($site->metaKeywords == '')
						{
							$keywords = false;
							$keywordsCount = 0;
						}
						
						?>
						<strong><i class="zmdi zmdi-tag text-muted check"></i> <?php echo __("Meta Keywords"); ?></strong>
						<small class="text-muted d-block subtitle"><?php echo ($keywordsCount); ?> <?php echo __("Detected"); ?></small>
					</div>
					<div class="col-lg-8">
						<?php foreach ($keywords as $key => $value) { 
							$value = rtrim(ltrim(badWords($value)));
							if(trim($value) != ''){
							?>
							<a  class="keyword" href="<?php echo base_url(); ?><?php echo config_item("slug_filter"); ?>/tag/<?php echo urlencode($value); ?>"><?php echo $value; ?></a>
						<?php } } ?>
						
						
					</div>
				</div>	
				<?php } ?>

				<?php
				$keyw = (extractKeyWords($site->body));
				if(count($keyw)>0 && $keyw != ''){ ?>
				<div class="row  p-t-2 hidden-md-down">
					<div class="col-lg-4">
						<?php
						

						
						?>
						<strong><i class="zmdi zmdi-tag text-muted check"></i> <?php echo __("Keywords Cloud"); ?></strong>
						<small class="text-muted d-block subtitle"><?php echo __("Density"); ?></small>
					</div>
					<div class="col-lg-8">
						<?php foreach ($keyw as $key => $value) { 
							$key = badWords($key);
							if(trim($key) != ''){
							?>
							<span  class="keyword-cloud"><?php echo more($key,30); ?><span class="value animated zoomIn"><?php echo $value; ?></span></span>
						<?php } } ?>
						
						
					</div>
				</div>
				

				<div class="row  p-t-2 hidden-md-down">
					<div class="col-lg-4">
						<?php
						$keyw = (extractKeyWords($site->body));

						
						?>
						<strong><i class="zmdi zmdi-badge-check text-muted check"></i> <?php echo __("Keyword Consistency"); ?></strong>
						<small class="text-muted d-block subtitle"><?php echo __("Keyword density is one of the main terms in SEO"); ?></small>
					</div>
					<div class="col-lg-8">
						<table class="consistency table">
							<tr class="header">
								<td><?php echo __("Keyword"); ?></td>
								<td class="text-xs-center"><?php echo __("Freq"); ?></td>
								<td class="text-xs-center"><?php echo __("Title"); ?></td>
								<td class="text-xs-center"><?php echo __("Desc"); ?></td>
								<td class="text-xs-center"><?php echo __("Domain"); ?></td>
								<td class="text-xs-center"><?php echo __("H1"); ?></td>
								<td class="text-xs-center"><?php echo __("H2"); ?></td>
							</tr>
							<?php
								foreach ($keyw as $key => $value) {
									?>
									<tr>
										<td><i class="zmdi zmdi-tag text-muted check"></i> <?php echo more(badWords($key),20); ?></td>
										<td class="text-xs-center "><?php echo $value; ?></td>
										<td class="text-xs-center">
											<?php
												if(mb_strpos(mb_strtolower($site->metaTitle),mb_strtolower($key)) !== FALSE)
												{
													?>
													<i class="zmdi zmdi-check text-success"></i> 
													<?php

												}
												else
												{
													?>
													<i class="zmdi zmdi-close text-danger"></i> 
													<?php
												}
											?>
										</td>

										<td class="text-xs-center">
											<?php
												if(mb_strpos(mb_strtolower($site->metaDescription),mb_strtolower($key)) !== FALSE)
												{
													?>
													<i class="zmdi zmdi-check text-success"></i> 
													<?php

												}
												else
												{
													?>
													<i class="zmdi zmdi-close text-danger"></i> 
													<?php
												}
											?>
										</td>

										<td class="text-xs-center">
											<?php
												if(mb_strpos(mb_strtolower($site->url),mb_strtolower($key)) !== FALSE)
												{
													?>
													<i class="zmdi zmdi-check text-success"></i> 
													<?php

												}
												else
												{
													?>
													<i class="zmdi zmdi-close text-danger"></i> 
													<?php
												}
											?>
										</td>	

										<td class="text-xs-center">
											<?php
												if(inHX($site->body,$key, "h1"))
												{
													?>
													<i class="zmdi zmdi-check text-success"></i> 
													<?php

												}
												else
												{
													?>
													<i class="zmdi zmdi-close text-danger"></i> 
													<?php
												}
											?>
										</td>	

										<td class="text-xs-center">
											<?php
												if(inHX($site->body,$key, "h2"))
												{
													?>
													<i class="zmdi zmdi-check text-success"></i> 
													<?php

												}
												else
												{
													?>
													<i class="zmdi zmdi-close text-danger"></i> 
													<?php
												}
											?>
										</td>


									</tr>
									<?php
								}
							?>
						</table>
						
						
					</div>
				</div>

				<?php } ?>
				<div class="row  p-t-2">
					<div class="col-lg-4">
						<strong><i class="zmdi zmdi-eye text-muted check"></i> <?php echo __("Google Preview"); ?></strong>
						<small class="text-muted d-block subtitle"><?php echo __("Your look like this in google search result "); ?></small>
					</div>
					<div class="col-lg-8">
						<div class="gsearch">
							<div class="title"><?php echo $metaTitle['fixed2']; ?></div>
							<div class="url"><?php echo badWords($site->url); ?></div>
							<div class="desc"><?php echo $metaDescription['fixed2']; ?></div>
						</div>
						
					</div>
				</div>

				<?php
					$detected[0] = __("File No Found");
					$detected[1] = __("File Detected");
				?>
				<div class="row  p-t-2">
					<div class="col-lg-4">
						<strong><i class="zmdi <?php echo getIcon($site->robots,0); ?> <?php echo getColor($site->robots,0); ?> check"></i> <?php echo __("Robots.txt"); ?></strong>
						<small class="text-muted d-block subtitle"><?php echo $detected[$site->robots]; ?></small>
					</div>
					<div class="col-lg-8">
						<a href="#">http://<?php echo $site->url; ?>/robots.txt</a>						
					</div>
				</div>


				<div class="row  p-t-2">
					<div class="col-lg-4">
						<strong><i class="zmdi  <?php echo getIcon($site->sitemap,0); ?> <?php echo getColor($site->sitemap,0); ?> check"></i> <?php echo __("Sitemap.xml"); ?></strong>
						<small class="text-muted d-block subtitle"><?php echo $detected[$site->sitemap]; ?></small>
					</div>
					<div class="col-lg-8">
						<a href="#">http://<?php echo $site->url; ?>/sitemap.xml</a>
						
					</div>
				</div>
				<?php /*
				<div class="row  p-t-2">
					<div class="col-lg-4">
						<strong><i class="zmdi zmdi-check text-success check"></i> <?php echo __("Domain Registration"); ?></strong>
						<small class="text-muted d-block subtitle"><?php echo __("Domain Information"); ?></small>
					</div>
					<div class="col-lg-8">
						
							<div><i class="zmdi zmdi-check text-success check"></i> Created 3 years ago</div>
							<div><i class="zmdi zmdi-check text-success check"></i> Expires in 3 years</div>
							<div><i class="zmdi zmdi-check text-success check"></i> Company: .CO Internet, S.A.S.</div>
						
						
					</div>
				</div>
				<?php */ ?>






			</div>
			
			<h2 class="light"><?php echo __("Estimation Traffic and Earnings"); ?></h2>

			<div class="card card-block">	
				<div class="row">
					<div class="col-lg-4">
						<div class="box-info blue">
							<div class="value"><?php echo number_format($site->uniqueVisitsDaily); ?> </div>
							<div class="title"><?php echo __("Unique Visits"); ?></div>
							<div class="subtitle"><?php echo __("Daily"); ?></div>
						</div>
					</div>

					<div class="col-lg-4">
						<div class="box-info orange">
							<div class="value"><?php echo number_format($site->pagesViewsDaily); ?></div>
							<div class="title"><?php echo __("Pages Views"); ?></div>
							<div class="subtitle"><?php echo __("Daily"); ?></div>
						</div>
					</div>
					
					<div class="col-lg-4">
						<div class="box-info green">
							<div class="value">$<?php echo number_format($site->IncomeDaily); ?></div>
							<div class="title"><?php echo __("Income"); ?></div>
							<div class="subtitle"><?php echo __("Daily"); ?></div>
						</div>
					</div>
				</div>

				<div class="row">
					<div class="col-lg-4">
						<div class="box-info blue">
							<div class="value"><?php echo number_format($site->uniqueVisitsDaily*28); ?></div>
							<div class="title"><?php echo __("Unique Visits"); ?></div>
							<div class="subtitle"><?php echo __("Monthly"); ?></div>
						</div>
					</div>

					<div class="col-lg-4">
						<div class="box-info orange">
							<div class="value"><?php echo number_format($site->pagesViewsDaily*28.5); ?></div>
							<div class="title"><?php echo __("Pages Views"); ?></div>
							<div class="subtitle"><?php echo __("Monthly"); ?></div>
						</div>
					</div>
					
					<div class="col-lg-4">
						<div class="box-info green">
							<div class="value">$<?php echo number_format($site->IncomeDaily*25); ?></div>
							<div class="title"><?php echo __("Income"); ?></div>
							<div class="subtitle"><?php echo __("Monthly"); ?></div>
						</div>
					</div>
				</div>


				<div class="row">
					<div class="col-lg-4">
						<div class="box-info blue">
							<div class="value"><?php echo number_format(($site->uniqueVisitsDaily*27)*12); ?></div>
							<div class="title"><?php echo __("Unique Visits"); ?></div>
							<div class="subtitle"><?php echo __("Yearly"); ?></div>
						</div>
					</div>

					<div class="col-lg-4">
						<div class="box-info orange">
							<div class="value"><?php echo number_format(($site->pagesViewsDaily*28)*12); ?></div>
							<div class="title"><?php echo __("Pages Views"); ?></div>
							<div class="subtitle"><?php echo __("Yearly"); ?></div>
						</div>
					</div>
					
					<div class="col-lg-4">
						<div class="box-info green">
							<div class="value">$<?php echo number_format(($site->IncomeDaily*22)*12); ?></div>
							<div class="title"><?php echo __("Income"); ?></div>
							<div class="subtitle"><?php echo __("Yearly"); ?></div>
						</div>
					</div>
				</div>

			</div>

			<?php 
			if(!$noADS)
				echo get_ads("ads3","ads card card-block p-b-1"); 
			?>

			<?php if(count($technologies)>0){ ?>
			<h2 class="light"><?php echo __("Technologies"); ?></h2>

			<div class="card card-block">
				
			<?php foreach ($technologies as $key => $value) { 
								?>
	
				<div class="col-md-6 p-b-2 p-t-1">
					<a class="media text-muted" href="<?php echo base_url(); ?><?php echo config_item("slug_filter"); ?>/made_with/<?php echo urlencode($value->name); ?>">
					  <span class="media-left">
					    <img class="media-object tec-img" src="<?php echo base_url(); ?>assets/images/icons/<?php echo $value->icon; ?>" alt="<?php echo $value->name; ?>">
					  </span>
					  <div class="media-body">
					    <h4 class="media-heading"><strong><?php echo $value->name; ?></strong></h4>
					    <div class="text-muted"><?php echo __($value->tag1); ?></div>
					  </div>
					</a>
				</div>

			<?php } ?>



			</div>

			<?php } ?>

			<h2 class="light"><?php echo __("Search Engine Indexing"); ?></h2>
			<div class="card card-block">

				<div class="row p-t-2 ">
					<div class="col-lg-4">
						<strong><i class="zmdi zmdi-google text-muted check"></i> <?php echo __("Google Indexed"); ?></strong>
						<small class="text-muted d-block subtitle"><?php echo number_format($site->googleIndex); ?> <?php echo __("Links"); ?></small>
					</div>
					<div class="col-lg-8">
						<progress class="progress" value="<?php echo getPor($site->googleIndex,100000); ?>" max="100"></progress>

					</div>
				</div>


				<div class="row p-t-2 ">
					<div class="col-lg-4">
						<strong><i class="zmdi zmdi-yahoo text-muted check"></i> <?php echo __("Yahoo Indexed"); ?></strong>
						<small class="text-muted d-block subtitle"><?php echo number_format($site->yahooIndex); ?> <?php echo __("Links"); ?></small>
					</div>
					<div class="col-lg-8">
						<progress class="progress" value="<?php echo getPor($site->yahooIndex,100000); ?>" max="100"></progress>

					</div>
				</div>


				<div class="row p-t-2 ">
					<div class="col-lg-4">
						<strong><i class="zmdi zmdi-windows text-muted check"></i> <?php echo __("Bing Indexed"); ?></strong>
						<small class="text-muted d-block subtitle"><?php echo number_format($site->bingIndex); ?> <?php echo __("Links"); ?></small>
					</div>
					<div class="col-lg-8">
						<progress class="progress" value="<?php echo getPor($site->bingIndex,100000); ?>" max="100"></progress>

					</div>
				</div>



			</div>
			
			<h2 class="light"><?php echo __("Speed And Optimization Tips"); ?></h2>
			<div class="card card-block">
				<div class="text-muted">
				<?php echo __("Website speed has a huge impact on performance, affecting user experience, conversion rates and even rankings. ‪‬‬By reducing page load-times, users are less likely to get distracted and the search engines are more likely to reward you by ranking your pages higher in the SERPs."); ?>
				</div>

				<div class="row p-t-2 ">
					<div class="col-lg-4">
						<strong><i class="zmdi <?php echo converTypeToIcon($optimize['title']); ?> text-<?php echo $optimize['title']; ?> check"></i> <?php echo __("Title Website"); ?></strong>
						<small class="d-block subtitle">
							<i class="zmdi zmdi-dot-circle"></i>
							<i class="zmdi zmdi-dot-circle text-muted"></i>
							<i class="zmdi zmdi-dot-circle text-muted"></i>
						</small>
					</div>
					<div class="col-lg-8">
						<?php echo createRecomendation($optimize['title'],'success',__("Congratulations! Your site title is optimized"),__("Warning! Your title website is not optimized")); ?>						
					</div>
				</div>

				<div class="row p-t-2 ">
					<div class="col-lg-4">
						<strong><i class="zmdi <?php echo converTypeToIcon($optimize['description']); ?> text-<?php echo $optimize['description']; ?> check"></i> <?php echo __("Description Website"); ?></strong>
						<small class="d-block subtitle">
							<i class="zmdi zmdi-dot-circle"></i>
							<i class="zmdi zmdi-dot-circle text-muted"></i>
							<i class="zmdi zmdi-dot-circle text-muted"></i>
						</small>
					</div>
					<div class="col-lg-8">
						<?php echo createRecomendation($optimize['description'],'success',__("Congratulations! Your description is optimized"),__("Warning! Your description website is not optimized")); ?>						
					</div>
				</div>


								

				<div class="row p-t-2 ">
					<div class="col-lg-4">
						<strong><i class="zmdi <?php echo converTypeToIcon($optimize['robots']); ?> text-<?php echo $optimize['robots']; ?> check"></i> <?php echo __("Robots.txt"); ?></strong>
						<small class="d-block subtitle">
							<i class="zmdi zmdi-dot-circle"></i>
							<i class="zmdi zmdi-dot-circle"></i>
							<i class="zmdi zmdi-dot-circle text-muted"></i>
						</small>
					</div>
					<div class="col-lg-8">
						<?php echo createRecomendation($optimize['robots'],'success',__("Congratulations! Your site uses a robots.txt"),__("Warning! Your site not have a robots.txt file")); ?>						
					</div>
				</div>

				<div class="row p-t-2 ">
					<div class="col-lg-4">
						<strong><i class="zmdi <?php echo converTypeToIcon($optimize['sitemap']); ?> text-<?php echo $optimize['sitemap']; ?> check"></i> <?php echo __("sitemap.xml"); ?></strong>
						<small class="d-block subtitle">
							<i class="zmdi zmdi-dot-circle"></i>
							<i class="zmdi zmdi-dot-circle"></i>
							<i class="zmdi zmdi-dot-circle text-muted"></i>
						</small>
					</div>
					<div class="col-lg-8">
						<?php echo createRecomendation($optimize['sitemap'],'success',__("Congratulations! We've found a sitemap file for your website"),__("Warning! Not found a sitemap file for your website")); ?>						
					</div>
				</div>
					
				<div class="row p-t-2 ">
					<div class="col-lg-4">
						<strong><i class="zmdi <?php echo converTypeToIcon($optimize['googleIndex']); ?> text-<?php echo $optimize['googleIndex']; ?> check"></i> <?php echo __("Google Links"); ?></strong>
						<small class="d-block subtitle">
							<i class="zmdi zmdi-dot-circle"></i>
							<i class="zmdi zmdi-dot-circle"></i>
							<i class="zmdi zmdi-dot-circle text-muted"></i>
						</small>
					</div>
					<div class="col-lg-8">
						<?php echo createRecomendation($optimize['googleIndex'],'success',__("Congratulations! You are indexed by google"),__("Warning! Your website is not indexed by google")); ?>						
					</div>
				</div>


				<div class="row p-t-2 ">
					<div class="col-lg-4">
						<strong><i class="zmdi <?php echo converTypeToIcon($optimize['https']); ?> text-<?php echo $optimize['https']; ?> check"></i> <?php echo __("SSL Secure"); ?></strong>
						<small class="d-block subtitle">
							<i class="zmdi zmdi-dot-circle"></i>
							<i class="zmdi zmdi-dot-circle text-muted"></i>
							<i class="zmdi zmdi-dot-circle text-muted"></i>
						</small>
					</div>
					<div class="col-lg-8">
						<?php echo createRecomendation($optimize['https'],'success',__("Congratulations! Your site have Support to HTTPS"),__("Warning! Your website is not SSL secured (HTTPS).")); ?>						
					</div>
				</div>	

				<div class="row p-t-2 ">
					<div class="col-lg-4">
						<strong><i class="zmdi <?php echo converTypeToIcon($optimize['pageSpeed']); ?> text-<?php echo $optimize['pageSpeed']; ?> check"></i> <?php echo __("Page Speed"); ?></strong>
						<small class="d-block subtitle">
							<i class="zmdi zmdi-dot-circle"></i>
							<i class="zmdi zmdi-dot-circle"></i>
							<i class="zmdi zmdi-dot-circle text-muted"></i>
						</small>
					</div>
					<div class="col-lg-8">
						<?php echo createRecomendation($optimize['pageSpeed'],'success',__("Congratulations! Your need improve the speed load for your site"),__("Warning! Slow loading web your site. need improve this")); ?>						
					</div>
				</div>


				<div class="row p-t-2 ">
					<div class="col-lg-4">
						<strong><i class="zmdi <?php echo converTypeToIcon($optimize['headers']); ?> text-<?php echo $optimize['headers']; ?> check"></i> <?php echo __("Headings"); ?></strong>
						<small class="d-block subtitle">
							<i class="zmdi zmdi-dot-circle"></i>
							<i class="zmdi zmdi-dot-circle"></i>
							<i class="zmdi zmdi-dot-circle text-muted"></i>
						</small>
					</div>
					<div class="col-lg-8">
						<?php echo createRecomendation($optimize['headers'],'success',__("Congratulations! You are using your H1 and H2 tags in your site"),__("Warning! Your page does not contain any H1 and H2 headings. H1 and H2 headings help indicate the important topics of your page to search engines")); ?>						
					</div>
				</div>

				<div class="row p-t-2 ">
					<div class="col-lg-4">
						<strong><i class="zmdi <?php echo converTypeToIcon($optimize['google_safe']); ?> text-<?php echo $optimize['google_safe']; ?> check"></i> <?php echo __("Blacklist"); ?></strong>
						<small class="d-block subtitle">
							<i class="zmdi zmdi-dot-circle"></i>
							<i class="zmdi zmdi-dot-circle"></i>
							<i class="zmdi zmdi-dot-circle text-muted"></i>
						</small>
					</div>
					<div class="col-lg-8">
						<?php echo createRecomendation($optimize['google_safe'],'success',__("Congratulations! Your site is not listed in a blacklist"),__("Error! Your site is listed in a blacklist")); ?>						
					</div>
				</div>

				<div class="row p-t-2 ">
					<div class="col-lg-4">
						<strong><i class="zmdi <?php echo converTypeToIcon($optimize['w3c']); ?> text-<?php echo $optimize['w3c']; ?> check"></i> <?php echo __("W3C Validator"); ?></strong>
						<small class="d-block subtitle">
							<i class="zmdi zmdi-dot-circle"></i>
							<i class="zmdi zmdi-dot-circle"></i>
							<i class="zmdi zmdi-dot-circle text-muted"></i>
						</small>
					</div>
					<div class="col-lg-8">
						<?php echo createRecomendation($optimize['w3c'],'success',__("Congratulations! Your site not have errors W3C"),__("Warning! Your site have errors W3C")); ?>						
					</div>
				</div>

				<div class="row p-t-2 ">
					<div class="col-lg-4">
						<strong><i class="zmdi <?php echo converTypeToIcon($optimize['domainAuthority']); ?> text-<?php echo $optimize['domainAuthority']; ?> check"></i> <?php echo __("Domain Authority"); ?></strong>
						<small class="d-block subtitle">
							<i class="zmdi zmdi-dot-circle"></i>
							<i class="zmdi zmdi-dot-circle"></i>
							<i class="zmdi zmdi-dot-circle text-muted"></i>
						</small>
					</div>
					<div class="col-lg-8">
						<?php echo createRecomendation($optimize['domainAuthority'],'success',__("Congratulations! Your Domain Authority is good"),__("Warning! Domain Authority of your website is slow. It is good to have domain authority more than 25.")); ?>						
					</div>
				</div>

				<div class="row p-t-2 ">
					<div class="col-lg-4">
						<strong><i class="zmdi <?php echo converTypeToIcon($optimize['gzip']); ?> text-<?php echo $optimize['gzip']; ?> check"></i> <?php echo __("GZIP Compress"); ?></strong>
						<small class="d-block subtitle">
							<i class="zmdi zmdi-dot-circle"></i>
							<i class="zmdi zmdi-dot-circle"></i>
							<i class="zmdi zmdi-dot-circle text-muted"></i>
						</small>
					</div>

					<div class="col-lg-8">
						<?php echo createRecomendation($optimize['gzip'],'success',__("Congratulations! Your website is compressed"),__("Warning! Your site not  is compressed, this can make slower response for the visitors")); ?>						
					</div>
				</div>


				<div class="row p-t-2 ">
					<div class="col-lg-4">
						<strong><i class="zmdi <?php echo converTypeToIcon($optimize['favicon']); ?> text-<?php echo $optimize['favicon']; ?> check"></i> <?php echo __("Favicon"); ?></strong>
						<small class="d-block subtitle">
							<i class="zmdi zmdi-dot-circle text-muted"></i>
							<i class="zmdi zmdi-dot-circle text-muted"></i>
							<i class="zmdi zmdi-dot-circle text-muted"></i>
						</small>
					</div>

					<div class="col-lg-8">
						<?php echo createRecomendation($optimize['favicon'],'success',__("Congratulations! Your website appears to have a favicon."),__("Warning!  Your site not have a favicon" )); ?>						
					</div>
				</div>

				<div class="row p-t-2 ">
					<div class="col-lg-4">
						<strong><i class="zmdi <?php echo converTypeToIcon($optimize['links']); ?> text-<?php echo $optimize['links']; ?> check"></i> <?php echo __("Broken Links"); ?></strong>
						<small class="d-block subtitle">
							<i class="zmdi zmdi-dot-circle"></i>
							<i class="zmdi zmdi-dot-circle"></i>
							<i class="zmdi zmdi-dot-circle text-muted"></i>
						</small>
					</div>

					<div class="col-lg-8">
						<?php echo createRecomendation($optimize['links'],'success',__("Congratulations! You not have broken links"),__("Warning!  You have broken links")); ?>						
						<div class="text-muted text-small p-t-1">
						<?php 
						$links = explode("<br>",$site->links);
						foreach ($links as $key => $value) {
							$value = str_ireplace("OK -", '<i class="zmdi zmdi-check text-success check"></i>', $value);
							$value = str_ireplace("ERROR -", '<i class="zmdi zmdi-close text-danger check"></i>', $value);
							?>
							<div class="truncate"> <?php echo badWords($value); ?></div>
							<?php
						}						
						?>
						</div>

					</div>
				</div>








				

				


			</div>

			<h2 class="light"><?php echo __("Alexa"); ?></h2>
				
				<div class="card card-block">
					<div class="row p-t-2 ">
						<div class="col-lg-6 text-xs-center ">
							<h2><?php echo number_format($site->alexaGlobal); ?></h2>
							<small class="d-block text-muted">
								 <?php echo __("Global Rank"); ?>
							</small>
						</div>
						<div class="col-lg-6 text-xs-center ">
							<h2><?php echo number_format($site->alexaLocal); ?></h2>
							<small class="d-block text-muted">
								 <?php 
								 $country = explode(",", $site->alexaLocalCountry);
								 echo $country[0]; ?>
							</small>
						</div>
						<?php if($country[1]){ ?>
						<div class="col-lg-12 text-xs-center p-t-2 ">
							<div id="map" class="map" data-country="<?php echo $country[1]; ?>" style="height:300px;width: 100%"></div>
						</div>
						<?php } ?>
					</div>
			
					
					<div class="row p-t-2 ">
						<div class="col-lg-6 img-alexa">
							<strong><?php echo __("Traffic"); ?></strong>
							<img class="img-fluid" src="http://traffic.alexa.com/graph?o=lt&y=t&b=ffffff&n=666666&f=999999&r=1y&t=2&z=30&c=1&h=300&w=500&u=<?php echo $site->url; ?>">
						</div>
						<div class="col-lg-6 img-alexa">
							<strong><?php echo __("Search"); ?></strong>
							<img class="img-fluid" src="http://traffic.alexa.com/graph?o=lt&y=q&b=ffffff&n=666666&f=999999&r=1y&t=2&z=30&c=1&h=300&w=500&u=<?php echo $site->url; ?>">
						</div>
						
					</div>
				</div>


			<h2 class="light"><?php echo __("Server Information"); ?></h2>
				
				<div class="card card-block">	
					<div class="row p-t-2 ">
						<div class="col-lg-4">							
							<strong><i class="zmdi zmdi-code check"></i> <?php echo __("Response Header"); ?></strong>
							<small class="text-muted d-block subtitle">						
								<?php echo __("HTTP headers carry information about the client browser, the requested page and the server"); ?>
							</small>
						</div>
				
						<div class="col-lg-8">
								<pre><?php echo rtrim(ltrim($site->headers)); ?></pre>
						</div>
					</div>
						<?php 						
						$ips = explode(";",$site->ip);


						if($ips[0] && $ips[0] != '127.0.0.1'){ 
							
							?>
					<div class="row p-t-2 ">
						<div class="col-lg-4">							
							<strong><i class="zmdi zmdi-globe check"></i> <?php echo __("IP Server"); ?></strong>
							<small class="text-muted d-block subtitle">						
								<?php echo __("The IP Address from server"); ?>
							</small>
						</div>
					
						<div class="col-lg-8">
								<?php 
								foreach ($ips as $key => $value) {
									if($value != ''){
									?><i class="zmdi zmdi-laptop-chromebook check"></i> <a class="text-muted" href="<?php echo base_url(); ?><?php echo config_item("slug_filter"); ?>/ip/<?php echo urlencode($value); ?>"><?php echo $value; ?></a><br><?php
									}
								}
							
								?>
						</div>

					
					</div>
					<?php if( $site->city){ ?>
					<div class="row p-t-2 ">
						<div class="col-lg-4">							
							<strong><i class="zmdi zmdi-info check"></i> <?php echo __("IP Details"); ?></strong>
							<small class="text-muted d-block subtitle">						
								<?php echo __("Information for IP address"); ?>
							</small>
						</div>
				
						<div class="col-lg-8">								
								<i class="zmdi zmdi-info-outline check"></i> <?php echo __("City:"); ?> <a class="text-muted" href="<?php echo base_url(); ?><?php echo config_item("slug_filter"); ?>/city/<?php echo urlencode($site->city); ?>"><?php echo $site->city; ?></a><br>
								<i class="zmdi zmdi-info-outline check"></i> <?php echo __("Country:"); ?> <a class="text-muted" href="<?php echo base_url(); ?><?php echo config_item("slug_filter"); ?>/country/<?php echo urlencode($site->country); ?>"><?php echo $site->country; ?></a><br>
								<i class="zmdi zmdi-info-outline check"></i> <?php echo __("Region:"); ?> <a class="text-muted" href="<?php echo base_url(); ?><?php echo config_item("slug_filter"); ?>/region/<?php echo urlencode($site->region); ?>"><?php echo $site->region; ?></a><br>
								<i class="zmdi zmdi-info-outline check"></i> <?php echo __("ISP:"); ?> <a class="text-muted" href="<?php echo base_url(); ?><?php echo config_item("slug_filter"); ?>/isp/<?php echo urlencode($site->isp); ?>"><?php echo $site->isp; ?></a><br>

								
								
						</div>
					</div>
					<?php } ?>
						
						<?php }	
						$result = dns_get_record($site->url);
						if(count($result)>1){
						?>
					

					<div class="row  p-t-2 hidden-md-down">
						<div class="col-lg-4">							
							<strong><i class="zmdi zmdi-info check"></i> <?php echo __("DNS Records"); ?></strong>
							<small class="text-muted d-block subtitle">						
								 <?php echo __("DNS Resource Records associated with a hostname"); ?>
							</small>
						</div>
				
						<div class="col-lg-8">
								<table class="consistency table">
									<tr class="header">										
										<td class="text-xs-"><?php echo __("Type"); ?></td>
										<td class="text-xs-center"><?php echo __("Pri"); ?></td>
										<td class="text-xs-center"><?php echo __("Target"); ?></td>
										<td class="text-xs-center"><?php echo __("Class"); ?></td>
										<td class="text-xs-center"><?php echo __("TTL"); ?></td>										
									</tr>
								<?php
								
								foreach ($result as $key => $value) {
									if(!$value['target'])
										$value['target'] = $value['ip'];
									?>
									<tr>
										<td><?php echo $value['type']; ?></td>
										<td class="text-xs-center text-muted"><?php echo $value['pri']; ?></td>
										<td class="text-xs-center "><?php echo $value['target']; ?></td>
										<td class="text-xs-center text-muted"><?php echo $value['class']; ?></td>
										<td class="text-xs-center "><?php echo $value['ttl']; ?></td>
									</tr>
									<?php
								}
								?>
								</table>
								
								
								
								
						</div>

						
						
					</div>
					<?php } ?>

				</div>




			</div>		
		</div>
		
	</div>
</div>